"""
Pregnancy Mega Mod - Bundled pregnancy mods
by java7nerd and Scumbumbo @ ModTheSims
version 1
  Pregnancy Scan by java7nerd
  Pregnancy Terminator by Scumbumbo
  Pregnancy Stage Set by Scumbumbo
  Pregnancy Set Offspring by java7nerd
version 2
  Make notification icon show actual target sim, not necessarily the active sim
"""
import sims4.commands
import sims.sim_info
import services
import random
import injector
from server_commands.argument_helpers import OptionalTargetParam, get_optional_target
from interactions.utils.pregnancy import PregnancyTracker
from sims.sim_info_types import Gender
from sims4.localization import LocalizationHelperTuning
from ui.ui_dialog_notification import UiDialogNotification

pregnancy_mod_sa_instance_ids = (17608706005782878675, 13258313599595875556, 12431788248176075451, 10828959797335572444, 12516343241685269456, 16297228746575716883, 16875503987194119605, 13289422938683429029, 16076073390687288507, 15166974486210900650, 12297688876669909841, 14860957603813878893, 16096621342874771492, 13990982727581675797, 11637166995536142081, 14845191716311232253, 11909138901736154070, 17428001930577429086, 18374731754723238021, 12876259103838842494)
    
@injector.inject_to(sims.sim.Sim, 'on_add')
def pregnancymod_add_super_affordances(original, self):
    original(self)
    sa_list = []
    affordance_manager = services.affordance_manager()
    for sa_id in pregnancy_mod_sa_instance_ids:
        tuning_class = affordance_manager.get(sa_id)
        if not tuning_class is None:
            sa_list.append(tuning_class)
    self._super_affordances = self._super_affordances + tuple(sa_list)

def pregnancymod_show_notification(text, title=None, sim_info=None):
    client = services.client_manager().get_first_client()
    if sim_info is None:
        sim_info = client.active_sim
    if title is None:
        title = "Pregnancy Mod"
    notification = UiDialogNotification.TunableFactory().default(client.active_sim, text=lambda **_: LocalizationHelperTuning.get_raw_text(text), title=lambda **_: LocalizationHelperTuning.get_raw_text(title))
    notification.show_dialog(icon_override=(None, sim_info))

def pregnancymod_show_scan_results(sim, title):
    if sim is None:
        return
    info = sim.sim_info
    pregnancy_tracker = info.pregnancy_tracker
    if pregnancy_tracker.is_pregnant:
        pregnancy_tracker.create_offspring_data()
        num_girls = 0
        num_boys = 0
        for offspring_data in pregnancy_tracker.get_offspring_data_gen():
            if offspring_data.gender == Gender.FEMALE:
                num_girls = num_girls + 1
            else:
                num_boys = num_boys + 1
        pregnancy_tracker._offspring_data = []
        if (num_girls, num_boys) == (1, 0):
            result = "{} is pregnant, it's a girl!".format(info.first_name)
        elif (num_girls, num_boys) == (0, 1):
            result = "{} is pregnant, it's a boy!".format(info.first_name)
        elif (num_girls, num_boys) == (2, 0):
            result = "{} is pregnant, it's twin girls!!".format(info.first_name)
        elif (num_girls, num_boys) == (1, 1):
            result = "{} is pregnant, it's twins, one girl and one boy!!".format(info.first_name)
        elif (num_girls, num_boys) == (0, 2):
            result = "{} is pregnant, it's twin boys!!".format(info.first_name)
        elif (num_girls, num_boys) == (3, 0):
            result = "{} is pregnant, it's triplet girls!!!".format(info.first_name)
        elif (num_girls, num_boys) == (2, 1):
            result = "{} is pregnant, it's triplets, two girls and a boy!!!".format(info.first_name)
        elif (num_girls, num_boys) == (1, 2):
            result = "{} is pregnant, it's triplets, one girls and a two boys!!!".format(info.first_name)
        elif (num_girls, num_boys) == (0, 3):
            result = "{} is pregnant, it's triplet boys!!!".format(info.first_name)
        elif num_girls + num_boys == 0: # should not be reached
            result = "{} is not pregnant".format(info.first_name)
        else: # should not be reached
            result = "{} is pregnant with {} girl(s) and {} boy(s)!".format(info.first_name, num_girls, num_boys)
    else:
        result = "{} is not pregnant.".format(info.first_name)
    pregnancymod_show_notification(result, title=title, sim_info=info)

@sims4.commands.Command('pregnancymod.scan',  command_type=sims4.commands.CommandType.Live)
def pregnancymod_scan(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_show_scan_results(sim, "Pregnancy Mod Scan")

def pregnancymod_setcommodity(sim, value):
    if sim is None:
        return
    info = sim.sim_info
    pregnancy_tracker = info.pregnancy_tracker
    if pregnancy_tracker.is_pregnant:
        if value != 0:
            pregnancy_tracker.clear_pregnancy_visuals()
            commodity_tracker = info.get_tracker(pregnancy_tracker.PREGNANCY_COMMODITY)
            commodity_tracker.set_value(pregnancy_tracker.PREGNANCY_COMMODITY, value)
        else:
            pregnancy_tracker.clear_pregnancy()

@sims4.commands.Command('pregnancymod.setnotshowing', command_type=sims4.commands.CommandType.Live)
def pregnancymod_setnotshowing(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setcommodity(sim, 1)

@sims4.commands.Command('pregnancymod.setfirsttrimester', command_type=sims4.commands.CommandType.Live)
def pregnancymod_setfirsttrimester(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setcommodity(sim, 25)

@sims4.commands.Command('pregnancymod.setsecondtrimester', command_type=sims4.commands.CommandType.Live)
def pregnancymod_setsecondtrimester(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setcommodity(sim, 49)

@sims4.commands.Command('pregnancymod.setthirdtrimester', command_type=sims4.commands.CommandType.Live)
def pregnancymod_setthirdtrimester(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setcommodity(sim, 73)

@sims4.commands.Command('pregnancymod.beginlabor', command_type=sims4.commands.CommandType.Live)
def pregnancymod_beginlabor(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setcommodity(sim, 97)

@sims4.commands.Command('pregnancymod.terminate', command_type=sims4.commands.CommandType.Live)
def pregnancymod_terminate(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setcommodity(sim, 0)

def pregnancymod_same(target, current):
    target = list(target)
    current = list(current)
    if len(target) != len(current):
        return False
    for i in range(len(target)):
        if current[i] == target[i] & current[i]:
            pass
        else:
            return False
    return True

def pregnancymod_get_babies(pregnancy_tracker):
    pregnancy_tracker.create_offspring_data()
    rv = []
    for offspring_data in pregnancy_tracker.get_offspring_data_gen():
        rv.append(int(offspring_data.gender))
    pregnancy_tracker._offspring_data = []
    return tuple(rv)

def pregnancymod_setoffspring(sim, baby1=None, baby2=None, baby3=None):
    if sim is None:
        return
    info = sim.sim_info
    pregnancy_tracker = info.pregnancy_tracker
    if not pregnancy_tracker.is_pregnant:
        return
    if not baby1 is None:
        target = [baby1]
        if baby2 != None:
            target.append(baby2)
        if baby3 != None:
            target.append(baby3)
        target = tuple(target)
        backup_seed = pregnancy_tracker._seed
        pregnancy_tracker._seed = random.getrandbits(32)
        i = 0
        current = pregnancymod_get_babies(pregnancy_tracker)
        while not pregnancymod_same(target, current):
            if i >= 20000:
                pregnancymod_show_notification("Unable to set offspring.  This is likely due to the lot size limit.", title="Pregnancy Mod Set Offspring", sim_info=info)
                pregnancy_tracker._seed = backup_seed
                return
            i = i + 1
            pregnancy_tracker._seed = random.getrandbits(32)
            current = pregnancymod_get_babies(pregnancy_tracker)
    else:
        pregnancy_tracker._seed = random.getrandbits(32)
    pregnancymod_show_scan_results(sim, "Pregnancy Mod Set Offspring")
   
@sims4.commands.Command('pregnancymod.setsinglegirl', command_type=sims4.commands.CommandType.Live)
def pregnancymod_setsinglegirl(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE))
    
@sims4.commands.Command('pregnancymod.setsingleboy', command_type=sims4.commands.CommandType.Live)
def pregnancymod_setsingleboy(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.MALE))

@sims4.commands.Command('pregnancymod.setsinglerandom', command_type=sims4.commands.CommandType.Live)
def pregnancymod_setsinglerandom(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE) | int(Gender.MALE))
    
@sims4.commands.Command('pregnancymod.settwinsgirls', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settwinsgirls(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE), int(Gender.FEMALE))
    
@sims4.commands.Command('pregnancymod.settwinsboys', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settwinsboys(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.MALE), int(Gender.MALE))

@sims4.commands.Command('pregnancymod.settwinsgirlboy', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settwinsgirlboy(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE), int(Gender.MALE))

@sims4.commands.Command('pregnancymod.settwinsrandom', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settwinsrandom(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE) | int(Gender.MALE), int(Gender.FEMALE) | int(Gender.MALE))
    
@sims4.commands.Command('pregnancymod.settripletsgirls', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settripletsgirls(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE), int(Gender.FEMALE), int(Gender.FEMALE))

@sims4.commands.Command('pregnancymod.settripletsboys', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settripletsboys(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.MALE), int(Gender.MALE), int(Gender.MALE))

@sims4.commands.Command('pregnancymod.settripletsgirlboyboy', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settripletsgirlboyboy(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE), int(Gender.MALE), int(Gender.MALE))

@sims4.commands.Command('pregnancymod.settripletsgirlgirlboy', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settripletsgirlgirlboy(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE), int(Gender.FEMALE), int(Gender.MALE))

@sims4.commands.Command('pregnancymod.settripletsrandom', command_type=sims4.commands.CommandType.Live)
def pregnancymod_settripletsrandom(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim, int(Gender.FEMALE) | int(Gender.MALE), int(Gender.FEMALE) | int(Gender.MALE), int(Gender.FEMALE) | int(Gender.MALE))
    
@sims4.commands.Command('pregnancymod.setrandom', command_type=sims4.commands.CommandType.Live)
def pregnancymod_setrandom(opt_sim:OptionalTargetParam=None, _connection=None):
    sim = get_optional_target(opt_sim, _connection)
    pregnancymod_setoffspring(sim)